#pragma once
#include "afxwin.h"

#include "MyColorStaticST.h"

// COLORSPACE TYPE
//
enum {

	COLORSPACE_TYEP_RGB24		= 0,						//   0xBBGGRR -> R0 G0 B0 R1 G1 B1 R2 G2 B2 ... >>

	COLORSPACE_TYEP_BGR24		= 1,						//   0xRRGGBB -> B0 G0 R0 B1 G1 R1 B2 G2 R2 ... >>

	COLORSPACE_TYEP_ARGB32	= 2,						// 0xAABBGGRR -> R0 G0 B0 A0 R1 G1 B1 A1 R2 G2 B2 A2 ... >>

	COLORSPACE_TYEP_ABGR32	= 3,						// 0xAARRGGBB -> B0 G0 R0 A0 B1 G1 R1 A1 B2 G2 R2 A2 ... >>

	COLORSPACE_TYEP_YUY2			= 0x32595559,	 // 0x32595559 -> MAKEFOURCC('Y', 'U', 'Y', '2')

	COLORSPACE_TYEP_UYVY		= 0x59565955,	// 0x59565955 -> MAKEFOURCC('U', 'Y', 'V', 'Y')

	COLORSPACE_TYEP_YV12			= 0x32315659,	// 0x32315659 -> MAKEFOURCC('Y', 'V', '1', '2') (Y V U)	
};

// CSetOSDBuffer dialog

class CSetOSDBuffer : public CDialogEx
{
	DECLARE_DYNAMIC(CSetOSDBuffer)

public:
	CSetOSDBuffer(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSetOSDBuffer();

// Dialog Data
	enum { IDD = IDD_SET_OSD_BUFFER_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedOk();
	afx_msg void OnBnClickedCancel();
	afx_msg void OnBnClickedBrowserBufferPath();	
	afx_msg void OnBnClickedSetAlphaBlending();
	afx_msg void OnBnClickedMoveTextObject();
	afx_msg void OnClickedScKeyColor();
	afx_msg void OnSelchangeComboKeyColorThresHold();
	DECLARE_MESSAGE_MAP()

public:	

	PVOID						m_pOSDAlphaBlender;

	int							m_nOSDLayer;
	
	int							m_nXOffset;

	int							m_nYOffset;

	int							m_nWidth;

	int							m_nHeight;

	int							m_nBufferTransparent;

	int							m_nSrcBufferWidth;

	int							m_nSrcBufferHeight;

	int							m_nColorSpace;

	ULONG					m_nKeyColorThreshold;

	COLORREF				m_clrKeyColor;

	 BYTE *					m_pFrameBuffer;

	CString						m_strLoadBuffer;

	CString						m_strBrowseFilePath;

	CComboBox			m_comboOSDBufferLayer;
	
	CComboBox			m_comboBufferColorSpace;
	
	CEdit						m_editBufferPath;

	MyColorStaticST		m_scKeyColor;

	CComboBox			m_comboKeyColorThresHold;
};
